﻿//////////////////////////////////////////////
// ThemeManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward Decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "Theme.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>
#include <unordered_map>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT ThemeManager final : public nkCommon::MaybeSingletonClass<ThemeManager>
	{
		public :

			// Getters
			System* getSystem () const ;
			Theme* getActiveTheme () const ;

			// Setters
			void setActiveTheme (Theme* theme) ;

			// Memory management
			Theme* createOrRetrieve (nkMemory::StringView name) ;
			Theme* record (nkMemory::StringView name, nkMemory::UniquePtr<Theme> resource) ;
			Theme* get (nkMemory::StringView name) const ;
			Theme* getByIndex (unsigned int index) const ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<Theme> relinquish (nkMemory::StringView name) ;

		private :
	
			// Functions
			// Constructors
			ThemeManager (bool isSingleton) noexcept ;
			ThemeManager (System* system) noexcept ;
			ThemeManager (const ThemeManager&) = delete ;

			// Operators
			ThemeManager& operator= (const ThemeManager&) = delete ;

		private :

			// Memory
			std::unordered_map<std::string, nkMemory::UniquePtr<Theme>> _themes ;
			System* _system ;

			Theme* _activeTheme ;

		private :

			friend class nkCommon::MaybeSingletonClass<ThemeManager> ;
			friend class System ;
	} ;
}